/*
 * 
 *  merge cu NodeMCU ESP32 S
board Ai Thinker
merge cu TFT 1.8 ST7735 

genereaza Hot Spot9AP0 cu 
  IP 192.168.4.1
  dupa incarcare pe Oled si Serial Monitor 
  apare adresa IP 192.169.4.1
  Se dexchide pe Android Chrome
  Se introdice 192.168.4.1/webserial
  apare pagina web
  tot ce se editeaza  pe telefon apare pe Oled
  
*/

#include <Arduino.h>
#include <WiFi.h>
#include <AsyncTCP.h>
#include <ESPAsyncWebServer.h>
#include <WebSerial.h>

AsyncWebServer server(80);

const char* ssid = "ESP32-HotSpot"; 
const char* password = "12345678"; 

#include <Wire.h>
#include <XTronical_ST7735.h> // Hardware-specific library
#include <SPI.h>
#define TFT_DC     2       // register select (stands for Data Control perhaps!)
#define TFT_RST   4         // Display reset pin, you can also connect this to the ESP32 reset                          // in which case, set this #define pin to -1!
#define TFT_CS   5       // Display enable (Chip select), if not enabled will not talk on SPI bus
Adafruit_ST7735 tft = Adafruit_ST7735(TFT_CS,  TFT_DC, TFT_RST);  


void recvMsg(uint8_t *data, size_t len){
  WebSerial.println("Received Data...");
  String d = "";
  for(int i=0; i < len; i++){
    d += char(data[i]);
    Serial.println(d);
    tft.setTextWrap(false);
  tft.fillScreen(ST7735_BLACK);
  tft.setCursor(0, 0);
  tft.setTextColor(ST7735_YELLOW);
  tft.setTextSize(2);
  tft.print(d);
  Serial.print(d);
  }
  WebSerial.println(d);
}

void setup() {
  Serial.begin(115200);
    WiFi.softAP(ssid, password);

    IPAddress IP = WiFi.softAPIP();
    Serial.print("AP IP address: ");
    Serial.println(IP);
    // WebSerial is accessible at "<IP Address>/webserial" in browser
    WebSerial.begin(&server);
    /* Attach Message Callback */
    WebSerial.msgCallback(recvMsg);
    server.begin();

    
   tft.init();   // initialize a ST7735S chip,
   tft.fillScreen(ST7735_BLACK);
  tft.setCursor(0, 0);
  tft.setTextColor(ST7735_WHITE);
  tft.setTextSize(2);
  tft.println("ST7735 webserial IP=");
  tft.print(IP);
  delay(5000);
    
}


void loop() {
  
    }
